<?php 

wp_enqueue_media();
wp_enqueue_script( 'wp-color-picker' );
wp_enqueue_script( 'wp-color-picker-alpha' );
wp_enqueue_script( 'ghostpool-color-field' );
wp_enqueue_script( 'ghostpool-media-field' );

$key_order = array(
	'background-color',
	'background-image',
	'background-repeat',
	'background-size',
	'background-attachment',
	'background-position',
	'background-clip',
	'background-origin',
);

$new_order = array();
foreach( $key_order as $key ) {
	if ( isset( $default[$key] ) ) {
		$new_order[$key] = $default[$key];
	}
}

if ( isset( $new_order ) ) {

	foreach( $new_order as $k => $v ) {				

		$new_id = $id . '-' . $k;
		$new_name = $name . '[' . $k . ']';
		$new_value = isset( $value[$k] ) ? $value[$k] : $v;
		$field_class = 'gp-' . $k . '-field';

		if ( 'background-color' === $k ) {

			echo '<span class="gp-color-picker-field gp-styling-field ' . $field_class . '">';
				
				echo '<label for="' . sanitize_html_class( $new_id ) . '" class="gp-label">' . esc_html__( 'Background Color', 'aardvark' ) . '</label>';
			
				echo '<input type="text" id="' . sanitize_html_class( $new_id ) . '" class="gp-input-text" name="' . esc_attr( $new_name ) . '" value="' . esc_attr( $new_value ) . '" data-id="' . sanitize_html_class( $new_id ) . '" data-alpha="true" data-default-color="' . esc_attr( $v ) . '" />';

			echo '</span>';

		} elseif ( 'background-image' === $k ) {
		
			echo '<span class="gp-media-field gp-styling-field ' . $field_class . '" data-id="' . sanitize_html_class( $new_id ) . '">';
			
				echo '<label for="' . sanitize_html_class( $new_id ) . '" class="gp-label">' . esc_html__( 'Background Image', 'aardvark' ) . '</label>';

				echo '<span id="gp-media-preview-' . sanitize_html_class( $new_id ) .'" class="gp-media-preview">';
					if ( $new_value ) {	
						if ( is_numeric( $new_value ) ) {					
							$media_thumb = wp_get_attachment_image_src( $new_value, 'thumbnail' );
							$media_thumb = $media_thumb[0];
						} else {
							$media_thumb = $new_value;
						}		
						echo '<img src="' . esc_url( $media_thumb ) . '" class="gp-image-thumbnail" alt="" />';
					}
				echo '</span>';

				$text = ( '' !== $new_value ) ? esc_html__( 'Change Image', 'aardvark' ) : esc_html__( 'Add Image', 'aardvark' );

				echo '<input type="button" id="gp-media-' . sanitize_html_class( $new_id ) . '" class="gp-media-button button button-primary" value="' . esc_attr( $text ) . '" data-add="' . esc_attr__( 'Add Image', 'aardvark' ) . '" data-change="' . esc_attr__( 'Change Image', 'aardvark' ) . '" />';

				$show_class = ( '' !== $new_value ) ? ' gp-show' : '';
				echo '<a class="gp-remove-media-button' . $show_class . '" id="gp-remove-media-' . sanitize_html_class( $new_id ) . '" href="#">' . esc_html__( 'Remove Image', 'aardvark' ) . '</a>';
		
				echo '<input type="hidden" id="' . sanitize_html_class( $new_id ) . '" name="' . esc_attr( $new_name ) . '" value="' . esc_attr( $new_value ) . '" />';
			
			echo '</span>';	
										
		} elseif ( 'background-repeat' === $k ) {
	
			echo '<span class="gp-select-field gp-styling-field ' . $field_class . '">';
				echo '<label for="' . sanitize_html_class( $new_id ) . '" class="gp-label">' . esc_html__( 'Background Repeat', 'aardvark' ) . '</label>';
				echo '<select id="' . sanitize_html_class( $new_id ) . '" class="post_form" name="' . esc_attr( $new_name ) . '">';
  					$option_values = array(
						'no-repeat' => esc_html__( 'No Repeat', 'aardvark' ),
                        'repeat'    => esc_html__( 'Repeat All', 'aardvark' ),
                        'repeat-x'  => esc_html__( 'Repeat Horizontally', 'aardvark' ),
                        'repeat-y'  => esc_html__( 'Repeat Vertically', 'aardvark' ),
                        'inherit'   => esc_html__( 'Inherit', 'aardvark' ),
					);
					foreach( $option_values as $option_key => $option_value ) {
						if ( $new_value === $option_key ) {
							$checked = ' selected="selected"';
						} else {
							$checked = '';
						}
						echo '<option value="' . esc_attr( $option_key ) . '" ' . $checked . '>' . esc_attr( $option_value ) . '</option>';
					}
				echo '</select>';
			echo '</span>';	
				
		} elseif ( 'background-size' === $k ) {
	
			echo '<span class="gp-select-field gp-styling-field ' . $field_class . '">';
				echo '<label for="' . sanitize_html_class( $new_id ) . '" class="gp-label">' . esc_html__( 'Background Size', 'aardvark' ) . '</label>';
				echo '<select id="' . sanitize_html_class( $new_id ) . '" class="post_form" name="' . esc_attr( $new_name ) . '">';
  					$option_values = array(
						'inherit' => esc_html__( 'Inherit', 'aardvark' ),
                        'cover'   => esc_html__( 'Cover', 'aardvark' ),
                        'contain' => esc_html__( 'Contain', 'aardvark' ),
					);
					foreach( $option_values as $option_key => $option_value ) {
						if ( $new_value === $option_key ) {
							$checked = ' selected="selected"';
						} else {
							$checked = '';
						}
						echo '<option value="' . esc_attr( $option_key ) . '" ' . $checked . '>' . esc_attr( $option_value ) . '</option>';
					}
				echo '</select>';
			echo '</span>';
										
		} elseif ( 'background-attachment' === $k ) {
	
			echo '<span class="gp-select-field gp-styling-field ' . $field_class . '">';
				echo '<label for="' . sanitize_html_class( $new_id ) . '" class="gp-label">' . esc_html__( 'Background Attachment', 'aardvark' ) . '</label>';
				echo '<select id="' . sanitize_html_class( $new_id ) . '" class="post_form" name="' . esc_attr( $new_name ) . '">';
  					$option_values = array(
						'fixed'   => esc_html__( 'Fixed', 'aardvark' ),
						'scroll'  => esc_html__( 'Scroll', 'aardvark' ),
						'inherit' => esc_html__( 'Inherit', 'aardvark' ),
					);
					foreach( $option_values as $option_key => $option_value ) {
						if ( $new_value === $option_key ) {
							$checked = ' selected="selected"';
						} else {
							$checked = '';
						}
						echo '<option value="' . esc_attr( $option_key ) . '" ' . $checked . '>' . esc_attr( $option_value ) . '</option>';
					}
				echo '</select>';
			echo '</span>';
			
		} elseif ( 'background-position' === $k ) {
	
			echo '<span class="gp-select-field gp-styling-field ' . $field_class . '">';
				echo '<label for="' . sanitize_html_class( $new_id ) . '" class="gp-label">' . esc_html__( 'Background Position', 'aardvark' ) . '</label>';
				echo '<select id="' . sanitize_html_class( $new_id ) . '" class="post_form" name="' . esc_attr( $new_name ) . '">';
  					$option_values = array(
						'left top'      => esc_html__( 'Left Top', 'aardvark' ),
                        'left center'   => esc_html__( 'Left center', 'aardvark' ),
                        'left bottom'   => esc_html__( 'Left Bottom', 'aardvark' ),
                        'center top'    => esc_html__( 'Center Top', 'aardvark' ),
                        'center center' => esc_html__( 'Center Center', 'aardvark' ),
                        'center bottom' => esc_html__( 'Center Bottom', 'aardvark' ),
                        'right top'     => esc_html__( 'Right Top', 'aardvark' ),
                        'right center'  => esc_html__( 'Right Center', 'aardvark' ),
                        'right bottom'  => esc_html__( 'Right Bottom', 'aardvark' ),
					);
					foreach( $option_values as $option_key => $option_value ) {
						if ( $new_value === $option_key ) {
							$checked = ' selected="selected"';
						} else {
							$checked = '';
						}
						echo '<option value="' . esc_attr( $option_key ) . '" ' . $checked . '>' . esc_attr( $option_value ) . '</option>';
					}
				echo '</select>';
			echo '</span>';
			
		} elseif ( 'background-clip' === $k ) {
	
			echo '<span class="gp-select-field gp-styling-field ' . $field_class . '">';
				echo '<label for="' . sanitize_html_class( $new_id ) . '" class="gp-label">' . esc_html__( 'Background Clip', 'aardvark' ) . '</label>';
				echo '<select id="' . sanitize_html_class( $new_id ) . '" class="post_form" name="' . esc_attr( $new_name ) . '">';
					echo '<option value=""></option>';
  					$option_values = array(
						'inherit'     => esc_html__( 'Inherit', 'aardvark' ),
                        'border-box'  => esc_html__( 'Border Box', 'aardvark' ),
                        'content-box' => esc_html__( 'Content Box', 'aardvark' ),
                        'padding-box' => esc_html__( 'Padding Box', 'aardvark' ),
					);
					foreach( $option_values as $option_key => $option_value ) {
						if ( $new_value === $option_key ) {
							$checked = ' selected="selected"';
						} else {
							$checked = '';
						}
						echo '<option value="' . esc_attr( $option_key ) . '" ' . $checked . '>' . esc_attr( $option_value ) . '</option>';
					}
				echo '</select>';
			echo '</span>';
			
		} elseif ( 'background-origin' === $k ) {
	
			echo '<span class="gp-select-field gp-styling-field ' . $field_class . '">';
				echo '<label for="' . sanitize_html_class( $new_id ) . '" class="gp-label">' . esc_html__( 'Background Origin', 'aardvark' ) . '</label>';
				echo '<select id="' . sanitize_html_class( $new_id ) . '" class="post_form" name="' . esc_attr( $new_name ) . '">';
					echo '<option value=""></option>';
  					$option_values = array(
						'inherit'     => esc_html__( 'Inherit', 'aardvark' ),
                        'border-box'  => esc_html__( 'Border Box', 'aardvark' ),
                        'content-box' => esc_html__( 'Content Box', 'aardvark' ),
                        'padding-box' => esc_html__( 'Padding Box', 'aardvark' ),
					);
					foreach( $option_values as $option_key => $option_value ) {
						if ( $new_value === $option_key ) {
							$checked = ' selected="selected"';
						} else {
							$checked = '';
						}
						echo '<option value="' . esc_attr( $option_key ) . '" ' . $checked . '>' . esc_attr( $option_value ) . '</option>';
					}
				echo '</select>';
			echo '</span>';
			
		}

	}

}