<?php 

if ( isset( $default ) ) {

	$count = 1;
		
	if ( is_array( $default ) ) {
		
		$count = count( $default );

		// Setting title
		$wp_customize->add_setting( 
			$id,
			array(
				'capability' => 'edit_theme_options',
				'type' => 'theme_mod',
			)
		);		
		$wp_customize->add_control(
			new GhostPool_Title_Control( 
			$wp_customize,
			$id,
			array(
				'label'      => $title . ' (' . $units . ')',
				'section'    => $section,
				'settings'   => $id,
				'type'       => 'title',
			) )
		);
			
		// Settings	
		foreach( $default as $k => $v ) {
				
			if ( $count > 1 ) {
				if ( 'padding-top' === $k ) {
					$title = esc_html__( 'Top', 'aardvark' );
				} elseif ( 'padding-right' === $k ) {
					$title = esc_html__( 'Right', 'aardvark' );
				} elseif ( 'padding-bottom' === $k ) {
					$title = esc_html__( 'Bottom', 'aardvark' );
				} elseif ( 'padding-left' === $k ) {
					$title = esc_html__( 'Left', 'aardvark' );
				} elseif ( 'margin-top' === $k ) {
					$title = esc_html__( 'Top', 'aardvark' );
				} elseif ( 'margin-right' === $k ) {
					$title = esc_html__( 'Right', 'aardvark' );
				} elseif ( 'margin-bottom' === $k ) {
					$title = esc_html__( 'Bottom', 'aardvark' );
				} elseif ( 'margin-left' === $k ) {
					$title = esc_html__( 'Left', 'aardvark' );
				}
			} else {
				$title = '';
			}
						
			$wp_customize->add_setting( 
				$id . '[' . $k . ']',
				array(
					'default' => $v,
					'capability' => 'edit_theme_options',
					'type' => 'option',
					'sanitize_callback' => 'ghostpool_sanitize_dimensions',
				)
			);
					
			$wp_customize->add_control(
				$id . '[' . $k . ']',
				array(
					'label'      => $title,
					'section'    => $section,
					'settings'   => $id . '[' . $k . ']',
					'type'       => 'text',
				)
			);
			
		}	
		
	}
	
}