<?php 

if ( class_exists( 'WP_Customize_Control' ) ) {
	
	class GhostPool_Section_Header_Control extends WP_Customize_Control {
		public function enqueue() {
			$framework = ghostpool_framework_data();
			wp_enqueue_style( 'ghostpool-framework-customizer' );
		}	
		public function render_content() {
			if ( ! empty( $this->label ) ) {
				echo '<h2 class="gp-section-header">' . $this->label . '</h2>';
			}
			if ( ! empty( $this->description ) ) {
				$description_id   = '_customize-description-' . $this->id;
				echo '<span id="' . sanitize_html_class( $description_id ) . '" class="description customize-control-description">' . $this->description . '</span>';
			}
		}			
	}

	class GhostPool_Title_Control extends WP_Customize_Control {
		
		public function enqueue() {
			$framework = ghostpool_framework_data();
			wp_enqueue_style( 'ghostpool-framework-customizer' );
		}	
		
		public function render_content() {
			if ( ! empty( $this->label ) ) {
				$id = '_customize-input-' . $this->id;
				echo '<label for="' . sanitize_html_class( $id ) . '" class="customize-control-title">' . esc_html( $this->label ) . '</label>';
			}
			if ( ! empty( $this->description ) ) {	
				$id = '_customize-input-' . $this->id;		
				$description_id   = '_customize-description-' . $this->id;
				echo '<span id="' . sanitize_html_class( $description_id ) . '" class="description customize-control-description">' . $this->description . '</span>';
			}
		}
					
	}

	
	class GhostPool_Select_Control extends WP_Customize_Control {

		public $gp_settings = '';

		public function enqueue() {
			$framework = ghostpool_framework_data();
			wp_enqueue_style( 'ghostpool-framework-customizer' );
		}
		
		public function render_content() {
			
			if ( ! empty( $this->label ) ) {
				$id = '_customize-input-' . $this->id;
				echo '<label for="' . sanitize_html_class( $id ) . '" class="customize-control-title">' . esc_html( $this->label ) . '</label>';
			}
			if ( ! empty( $this->description ) ) {			
				$description_id   = '_customize-description-' . $this->id;
				echo '<span id="' . sanitize_html_class( $description_id ) . '" class="description customize-control-description">' . $this->description . '</span>';
			}
			
			$name = $this->id;
			$value =  $this->value();
			$this->gp_settings['link'] = ' ' . $this->get_link();

			// Load field types
			ghostpool_settings_field_types( $name, $value, $this->gp_settings );
			
		}
		
	}
	
	/*
	TO DO
	class GhostPool_Color_Control extends WP_Customize_Control {

		public $type = 'color-rgba';

		public function enqueue() {
			wp_enqueue_script( 'wp-color-picker' );
			wp_enqueue_style( 'wp-color-picker' );
			wp_enqueue_script( 'wp-color-picker-alpha' );
			wp_enqueue_script( 'ghostpool-color-field' );
		}

		public function to_json() {
			parent::to_json();
	
			$this->json['id'] = $this->id;
			$this->json['value'] = $this->value();
			$this->json['defaultValue'] = $this->setting->default;
		}	

		public function render_content() {}

		public function content_template() { ?>

			<# if ( data.label ) { #>
				<span class="customize-control-title">{{{ data.label }}}</span>
			<# } #>
			<# if ( data.description ) { #>
				<span class="description customize-control-description">{{{ data.description }}}</span>
			<# } #>

			<span class="gp-color-picker-field">
				<input class="gp-color-input" id="{{ data.id }}" type="text" value="{{data.value}}" data-id="{{ data.id }}" data-alpha="true" data-default-color="{{ data.defaultValue }}" />
			</span>
	
			<?php
		}
		
	}
	
	function ghostpool_customize_register( $wp_customize ) {	
		$wp_customize->register_control_type( 'GhostPool_Color_Control' );
	}
	add_action( 'customize_register', 'ghostpool_customize_register' );*/

}