<?php if ( ! class_exists( 'GhostPool_Page_Builder' ) ) {
	class GhostPool_Page_Builder {

		public function __construct() {
		
			global $pagenow;
		
			if ( 'post.php' === $pagenow OR 'post-new.php' === $pagenow ) {
				add_action( 'admin_enqueue_scripts', array( $this, 'enqueue_scripts' ) );
			}
				
			add_action( 'wp_enqueue_scripts', array( $this, 'remove_lightbox' ), 9999 );	
						
			add_action( 'vc_before_init', array( $this, 'page_builder_defaults' ), 9 );
			
			add_filter( 'vc_base_build_shortcodes_custom_css', array( $this, 'shortcodes_custom_css' ) );
			
			add_action( 'vc_load_default_templates_action', array( $this, 'load_templates' ) );
	
			vc_add_shortcode_param( 'gp_header', array( $this, 'header_field' ) );
			
			add_filter( 'vc_gitem_zone_image_block_link', array( $this, 'ghostpool_gitem_zone_image_block_link' ), 10, 2 );
			
			$this->load_files();			
		
		}

		public function enqueue_scripts() {
				
			wp_enqueue_style( 'ghostpool-page-builder', get_template_directory_uri() . '/lib/framework/page-builder/assets/page-builder.css', array( 'js_composer' ), AARDVARK_THEME_VERSION );	
			
			wp_enqueue_script( 'ghostpool-page-builder', get_template_directory_uri() . '/lib/framework/page-builder/assets/page-builder.js', array( 'jquery' ), AARDVARK_THEME_VERSION, true );			

		}

		public function load_files() {
			require_once( get_theme_file_path( '/lib/framework/page-builder/custom-options.php' ) );
			require_once( get_theme_file_path( '/lib/framework/page-builder/bp-options.php' ) );
			require_once( get_theme_file_path( '/lib/framework/page-builder/bp-profile-search-options.php' ) );
			require_once( get_theme_file_path( '/lib/framework/page-builder/carousel-posts-options.php' ) );
			require_once( get_theme_file_path( '/lib/framework/page-builder/carousel-images-options.php' ) );
			require_once( get_theme_file_path( '/lib/framework/page-builder/events-options.php' ) );
			require_once( get_theme_file_path( '/lib/framework/page-builder/events-calendar-options.php' ) );
			require_once( get_theme_file_path( '/lib/framework/page-builder/featured-box-options.php' ) );
			require_once( get_theme_file_path( '/lib/framework/page-builder/login-register-form-options.php' ) );
			require_once( get_theme_file_path( '/lib/framework/page-builder/particles-options.php' ) );
			require_once( get_theme_file_path( '/lib/framework/page-builder/pmp-register-form-options.php' ) );
			require_once( get_theme_file_path( '/lib/framework/page-builder/posts-options.php' ) );
			require_once( get_theme_file_path( '/lib/framework/page-builder/post-submission-form-options.php' ) );
			require_once( get_theme_file_path( '/lib/framework/page-builder/post-submission-form-2-options.php' ) );
			require_once( get_theme_file_path( '/lib/framework/page-builder/pricing-column-options.php' ) );
			require_once( get_theme_file_path( '/lib/framework/page-builder/sensei-courses-options.php' ) );
			require_once( get_theme_file_path( '/lib/framework/page-builder/showcase-options.php' ) );
			require_once( get_theme_file_path( '/lib/framework/page-builder/statistics-options.php' ) );
			require_once( get_theme_file_path( '/lib/framework/page-builder/team-options.php' ) );
			require_once( get_theme_file_path( '/lib/framework/page-builder/testimonial-slider-options.php' ) );		
		}

		public function page_builder_defaults() {
			
			// Disable design options 
			if ( true === apply_filters( 'ghostpool_disable_wpb_auto_updates', true ) ) {
				vc_set_as_theme();
			}
			
			// Enabled specified post types by default		
			vc_set_default_editor_post_types( array( 'page' ) );

			// Remove Visual Composer activation notice
			if ( is_admin() ) { 
				setcookie( 'vchideactivationmsg', '1', strtotime( '+3 years' ), '/' );
				setcookie( 'vchideactivationmsg_vc11', ( defined( 'WPB_VC_VERSION' ) ? WPB_VC_VERSION : '1' ), strtotime( '+3 years' ), '/' );
			}
						
		}

		public function header_field( $settings, $value ) {
			return '<input name="' . esc_attr( $settings['param_name'] ) . '" class="wpb_vc_param_value wpb-textinput ' . esc_attr( $settings['param_name'] ) . ' ' . esc_attr( $settings['type'] ) . '_field" type="hidden" value="' . esc_attr( $value ) . '" />';
		}
						
		public function remove_lightbox() {
			wp_dequeue_script( 'prettyphoto' );
			wp_deregister_script( 'prettyphoto' );
			wp_dequeue_style( 'prettyphoto' );
			wp_deregister_style( 'prettyphoto' );
		}

		// Remove !important tag from background center position
		public function shortcodes_custom_css( $css ) {
			if ( stripos( $css, '' ) !== false ) {
				$css = str_replace( 'background-position: center !important;', 'background-position: center;', $css );
			}
			return $css;
		}

		function ghostpool_gitem_zone_image_block_link( $image_block, $link ) {
		
			if ( 'image_lightbox' === $link && 'disabled' !== ghostpool_option( 'lightbox' ) ) {
				return '<a href="{{ post_image_url }}" title="{{ post_title }}" class="gp-wpb-lightbox-image" data-featherlight></a>';
			} else {
				return $image_block;
			}
			
		}
	
		public function load_templates( $data ) {
		
			// Login page template
			$data = array();
			$data['name'] = esc_html__( 'Login Page', 'aardvark' );
			$data['custom_class'] = 'gp-login-wpb-template';
			$data['content'] = '[vc_row full_width="stretch_row" full_height="yes" content_placement="middle" animated_bg="true" gradient_color_1="rgba(236,77,59,0.7)" gradient_color_2="rgba(242,109,60,0.7)" gradient_color_3="rgba(236,77,59,0.7)" gradient_color_4="rgba(255,178,171,0.7)" css=".vc_custom_1519134581072{padding-right: 30px !important;padding-left: 30px !important;}"][vc_column width="1/12" offset="vc_col-lg-4 vc_col-md-3 vc_hidden-xs"][/vc_column][vc_column width="5/6" css=".vc_custom_1519135457300{padding-top: 30px !important;padding-right: 30px !important;padding-bottom: 30px !important;padding-left: 30px !important;background-color: #ffffff !important;border-radius: 3px !important;}" offset="vc_col-lg-4 vc_col-md-6 vc_col-xs-12"][vc_single_image image="713" img_size="150x31" alignment="center"][gp_login_register_form][/vc_column][vc_column width="1/12" offset="vc_col-lg-4 vc_col-md-3 vc_hidden-xs"][/vc_column][/vc_row]';		
			vc_add_default_templates( $data );	

			// Pricing table 1
			$data = array();
			$data['name'] = esc_html__( 'Pricing Table 1', 'aardvark' );
			$data['custom_class'] = 'gp-pricing-table-1-wpb-template';
			$data['content'] = '[vc_row equal_height="yes"][vc_column width="1/4" smallbbresponsive=".bb_custom_1512739745266{margin-bottom: 30px !important;}"][gp_pricing_column title="Basic" currency_symbol="$" price="15" payment_interval="per month" button_text="Order" button_link="#" title_text_color="#ffffff" price_bg_color="#f8f8f8" content_bg_color="#f8f8f8" footer_bg_color="#f8f8f8" button_text_color="#ffffff" border_color="#58892a" styling_divider_begin="" styling_divider_end=""]
<ul>
 	<li>25 photos</li>
 	<li>30 minutes</li>
 	<li>Medium photos</li>
 	<li>1 canvas</li>
</ul>
[/gp_pricing_column][/vc_column][vc_column width="1/4" smallbbresponsive=".bb_custom_1512739758383{margin-bottom: 30px !important;}"][gp_pricing_column title="Standard" currency_symbol="$" price="30" payment_interval="per month" button_text="Order" button_link="#" title_text_color="#ffffff" price_bg_color="#f8f8f8" content_bg_color="#f8f8f8" footer_bg_color="#f8f8f8" button_text_color="#ffffff" border_color="#58892a"]
<ul>
 	<li>50 photos</li>
 	<li>60 minutes</li>
 	<li>2 large prints</li>
 	<li>2 canvases</li>
</ul>
[/gp_pricing_column][/vc_column][vc_column width="1/4" smallbbresponsive=".bb_custom_1512739766245{margin-bottom: 30px !important;}"][gp_pricing_column title="Premium" currency_symbol="$" price="90" payment_interval="per month" highlight="gp-highlight-column" highlight_text="Featured" button_text="Order" button_link="#" highlight_title_bg_color="#39c8df" title_text_color="#ffffff" highlight_title_text_color="#ffffff" price_bg_color="#f8f8f8" content_bg_color="#f8f8f8" footer_bg_color="#f8f8f8" button_text_color="#ffffff" border_color="#58892a"]
<ul>
 	<li>100 photos</li>
 	<li>90 minutes</li>
 	<li>2 large prints</li>
 	<li>2 canvases</li>
</ul>
[/gp_pricing_column][/vc_column][vc_column width="1/4" smallbbresponsive=".bb_custom_1512739774824{margin-bottom: 30px !important;}"][gp_pricing_column title="Ultimate" currency_symbol="$" price="200" payment_interval="per month" button_text="Order" button_link="#" title_text_color="#ffffff" price_bg_color="#f8f8f8" content_bg_color="#f8f8f8" footer_bg_color="#f8f8f8" button_text_color="#ffffff" border_color="#58892a"]
<ul>
 	<li>200 photos</li>
 	<li>120 minutes</li>
 	<li>4 large prints</li>
 	<li>3 canvases</li>
</ul>
[/gp_pricing_column][/vc_column][/vc_row]';		
			vc_add_default_templates( $data );	
			
			// Pricing table 2
			$data = array();
			$data['name'] = esc_html__( 'Pricing Table 2', 'aardvark' );
			$data['custom_class'] = 'gp-pricing-table-2-wpb-template';
			$data['content'] = '[vc_row equal_height="yes" css_animation="fadeIn" x_largebbresponsive=".bb_custom_1512739891520{padding-right: 10px !important;padding-left: 10px !important;}"][vc_column width="1/4" css=".vc_custom_1512739844531{padding-top: 0px !important;padding-right: 1px !important;padding-bottom: 0px !important;padding-left: 0px !important;}" smallbbresponsive=".bb_custom_1512739844536{margin-bottom: 30px !important;}"][gp_pricing_column title="Personal" currency_symbol="$" price="29" payment_interval="per month" button_text="Sign Up" button_link="/hosting/membership-account/membership-checkout/?level=1" style="gp-style-2" title_bg_color="#e73c7e" title_text_color="#ffffff" price_bg_color="#e73c7e" price_circle_color="#ffffff" content_bg_color="#e73c7e" content_bg_color_alt="#b9285f" content_text_color="#ffffff" footer_bg_color="#b9285f" button_bg_color="#232323" button_bg_hover_color="#000000" button_text_color="#ffffff" header_title="Personal" header_title_bg_color="#4b99a4" header_title_text_color="#ffffff" interval="per month" title_color="#ffffff" background_color="#ffffff" text_color="#232323"]
<ul>
 	<li>25K Visits/Mo.</li>
 	<li>10GB Local Storage</li>
 	<li>Free SSL Certificate</li>
 	<li>60 day money back guarantee</li>
</ul>
[/gp_pricing_column][/vc_column][vc_column width="1/4" css=".vc_custom_1512739852551{padding-top: 0px !important;padding-right: 1px !important;padding-bottom: 0px !important;padding-left: 1px !important;}" smallbbresponsive=".bb_custom_1512739852555{margin-bottom: 30px !important;}"][gp_pricing_column title="Professional" currency_symbol="$" price="99" payment_interval="per month" button_text="Sign Up" button_link="/hosting/membership-account/membership-checkout/?level=1" style="gp-style-2" title_bg_color="#ee7752" title_text_color="#ffffff" price_bg_color="#ee7752" price_circle_color="#ffffff" content_bg_color="#ee7752" content_bg_color_alt="#e0604c" content_text_color="#ffffff" footer_bg_color="#e0604c" button_bg_color="#232323" button_bg_hover_color="#000000" button_text_color="#ffffff" header_title="Personal" header_title_bg_color="#4b99a4" header_title_text_color="#ffffff" interval="per month" title_color="#ffffff" background_color="#ffffff" text_color="#232323"]
<ul>
 	<li>100K Visits/Mo.</li>
 	<li>20GB Local Storage</li>
 	<li>Unlimited SSL Certificates</li>
 	<li>60 day money back guarantee</li>
</ul>
[/gp_pricing_column][/vc_column][vc_column width="1/4" css=".vc_custom_1512739861506{padding-top: 0px !important;padding-right: 1px !important;padding-bottom: 0px !important;padding-left: 1px !important;}" smallbbresponsive=".bb_custom_1512739861510{margin-bottom: 30px !important;}"][gp_pricing_column title="Business" currency_symbol="$" price="249" payment_interval="per month" button_text="Sign Up" button_link="/hosting/membership-account/membership-checkout/?level=1" style="gp-style-2" title_bg_color="#39e0c1" title_text_color="#ffffff" price_bg_color="#39e0c1" price_circle_color="#ffffff" content_bg_color="#39e0c1" content_bg_color_alt="#2fbca9" content_text_color="#ffffff" footer_bg_color="#2fbca9" button_bg_color="#232323" button_bg_hover_color="#000000" button_text_color="#ffffff" header_title="Personal" header_title_bg_color="#4b99a4" header_title_text_color="#ffffff" interval="per month" title_color="#ffffff" background_color="#ffffff" text_color="#232323"]
<ul>
 	<li>500K Visits/Mo.</li>
 	<li>100GB Local Storage</li>
 	<li>Unlimited SSL Certificates</li>
 	<li>60 day money back guarantee</li>
</ul>
[/gp_pricing_column][/vc_column][vc_column width="1/4" css=".vc_custom_1512739868003{padding-top: 0px !important;padding-right: 0px !important;padding-bottom: 0px !important;padding-left: 1px !important;}" smallbbresponsive=".bb_custom_1512739868006{margin-bottom: 30px !important;}"][gp_pricing_column title="Premium" currency_symbol="$" price="499" payment_interval="per month" button_text="Sign Up" button_link="/hosting/membership-account/membership-checkout/?level=1" style="gp-style-2" title_bg_color="#39c8df" title_text_color="#ffffff" price_bg_color="#39c8df" price_circle_color="#ffffff" content_bg_color="#39c8df" content_bg_color_alt="#31a2bf" content_text_color="#ffffff" footer_bg_color="#31a2bf" button_bg_color="#232323" button_bg_hover_color="#000000" button_text_color="#ffffff" header_title="Personal" header_title_bg_color="#4b99a4" header_title_text_color="#ffffff" interval="per month" title_color="#ffffff" background_color="#ffffff" text_color="#232323"]
<ul>
 	<li>Unlimited Visits/Mo.</li>
 	<li>Unlimited Local Storage</li>
 	<li>Unlimited SSL Certificates</li>
 	<li>60 day money back guarantee</li>
</ul>
[/gp_pricing_column][/vc_column][/vc_row]';		
			vc_add_default_templates( $data );	

			// Pricing table 3
			$data = array();
			$data['name'] = esc_html__( 'Pricing Table 3', 'aardvark' );
			$data['custom_class'] = 'gp-pricing-table-3-wpb-template';
			$data['content'] = '[vc_row equal_height="yes" css_animation="fadeIn"][vc_column width="1/3" smallbbresponsive=".bb_custom_1512739903405{margin-bottom: 30px !important;}"][gp_pricing_column title="Bronze" currency_symbol="$" price="25" payment_interval="per month" button_text="Sign Up" button_link="/hosting/membership-account/membership-checkout/?level=1" style="gp-style-3" title_text_color="#ffffff" price_bg_color="#232323" price_text_color="#ffffff" content_bg_color="#232323" content_text_color="#ffffff" footer_bg_color="#232323" button_text_color="#ffffff" divider_color="#232323" header_title="Personal" header_title_bg_color="#4b99a4" header_title_text_color="#ffffff" interval="per month" title_color="#ffffff" background_color="#ffffff" text_color="#232323"]
<ul>
 	<li>25K Visits/Mo.</li>
 	<li>10GB Local Storage</li>
 	<li>Free SSL Certificate</li>
 	<li>60 day money back guarantee</li>
</ul>
[/gp_pricing_column][/vc_column][vc_column width="1/3" smallbbresponsive=".bb_custom_1512739908928{margin-bottom: 30px !important;}"][gp_pricing_column title="Silver" currency_symbol="$" price="50" payment_interval="per month" highlight="gp-highlight-column" highlight_text="Best Value" button_text="Sign Up" button_link="/hosting/membership-account/membership-checkout/?level=1" style="gp-style-3" highlight_title_bg_color="#232323" title_text_color="#ffffff" highlight_title_text_color="#ffffff" price_bg_color="#232323" price_text_color="#ffffff" content_bg_color="#232323" content_text_color="#ffffff" footer_bg_color="#232323" button_text_color="#ffffff" divider_color="#232323" header_title="Personal" header_title_bg_color="#4b99a4" header_title_text_color="#ffffff" interval="per month" title_color="#ffffff" background_color="#ffffff" text_color="#232323"]
<ul>
 	<li>25K Visits/Mo.</li>
 	<li>10GB Local Storage</li>
 	<li>Free SSL Certificate</li>
 	<li>60 day money back guarantee</li>
</ul>
[/gp_pricing_column][/vc_column][vc_column width="1/3" smallbbresponsive=".bb_custom_1512739915599{margin-bottom: 30px !important;}"][gp_pricing_column title="Gold" currency_symbol="$" price="100" payment_interval="per month" button_text="Sign Up" button_link="/hosting/membership-account/membership-checkout/?level=1" style="gp-style-3" title_text_color="#ffffff" price_bg_color="#232323" price_text_color="#ffffff" content_bg_color="#232323" content_text_color="#ffffff" footer_bg_color="#232323" button_text_color="#ffffff" divider_color="#232323" header_title="Personal" header_title_bg_color="#4b99a4" header_title_text_color="#ffffff" interval="per month" title_color="#ffffff" background_color="#ffffff" text_color="#232323"]
<ul>
 	<li>25K Visits/Mo.</li>
 	<li>10GB Local Storage</li>
 	<li>Free SSL Certificate</li>
 	<li>60 day money back guarantee</li>
</ul>
[/gp_pricing_column][/vc_column][/vc_row]';		
			vc_add_default_templates( $data );	
									
		}


	}
}	
new GhostPool_Page_Builder();