<?php get_header();

/**
 * Get settings
 *
 */
$settings = get_query_var( 'ghostpool_page_settings' );
if ( $settings && is_array( $settings ) ) {
	extract( $settings );
}

// Classes
$css_classes = array(
	'gp-posts-wrapper',
	'gp-archive-wrapper',
	$format,
	$style,
	$alignment,
);
$css_classes = trim( implode( ' ', array_filter( array_unique( $css_classes ) ) ) );

?>

<?php ghostpool_page_header( '', $header, $header_bg, $header_height ); ?>

<?php if ( 'gp-minimal-page-header' !== $header ) { ghostpool_page_title( '', $header ); } ?>

<div id="gp-content-wrapper" class="gp-container">

	<?php do_action( 'ghostpool_begin_content_wrapper' ); ?>
		
	<div id="gp-inner-container">

		<div id="gp-content">
		
			<?php if ( 'gp-minimal-page-header' === $header ) { ghostpool_page_title( '', $header ); } ?>

			<?php if ( ! function_exists( 'elementor_theme_do_location' ) OR ! elementor_theme_do_location( 'archive' ) ) { ?>

				<div class="<?php echo esc_attr( $css_classes ); ?>" data-type="author"<?php if ( function_exists( 'ghostpool_filter_variables' ) ) { echo ghostpool_filter_variables( $settings ); } ?>>
				
					<?php ghostpool_filter( $settings ); ?>
		
					<div class="gp-section-loop <?php echo sanitize_html_class( ghostpool_option( 'ajax' ) ); ?>">

						<?php if ( have_posts() ) : ?>
					
							<div class="gp-section-loop-inner">							
								<?php if ( $format == 'gp-posts-masonry' ) { ?><div class="gp-gutter-size"></div><?php } ?>							
								<?php while ( have_posts() ) : the_post();
									get_template_part( 'lib/sections/taxonomies/post-loop-standard' ); 
								endwhile; ?>
							</div>

							<?php echo ghostpool_pagination( $wp_query->max_num_pages, $pagination ); ?>

						<?php else : ?>

							<strong class="gp-no-items-found"><?php esc_html_e( 'No items found.', 'aardvark' ); ?></strong>

						<?php endif; ?>
				
					</div>

				</div>			
			
			<?php } ?>
			
		</div>

		<?php get_sidebar( 'left' ); ?>

		<?php get_sidebar( 'right' ); ?>
	
	</div>

	<?php do_action( 'ghostpool_end_content_wrapper' ); ?>
			
	<div class="gp-clear"></div>

</div>

<?php get_footer();